#include <iostream>
#include <vector>
#include <algorithm>

std::vector<int> constructQ(const std::vector<int>& P) {
    int N = P.size() - 1;
    std::vector<int> Q(N + 1, 0);

    for (int i = 0; i <= N; ++i) {
        Q[P[i]] = i;
    }

    return Q;
}

int calculateMaxX(const std::vector<int>& P, const std::vector<int>& Q) {
    int maxX = 0, N = P.size();
    for (int i = 0; i < N; ++i) {
        maxX += P[i] ^ Q[i];
    }
    return maxX;
}

int main() {
    int T, N;
    std::cin >> T;

    while (T--) {
        std::cin >> N;
        std::vector<int> P(N + 1);
        for (int i = 0; i <= N; ++i) {
            std::cin >> P[i];
        }

        std::vector<int> Q = constructQ(P);
        int maxX = calculateMaxX(P, Q);

        std::cout << maxX << std::endl;
        for (int i = 0; i <= N; ++i) {
            std::cout << Q[i] << " ";
        }
        std::cout << std::endl;
    }

    return 0;
}